#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

using namespace std;

int citiesCount, roadsCount;
int cityFrom, cityTo;

struct Edge {
	int to, flow, capacity;
	Edge * rev;
	
	Edge(int to, int capacity) : to(to), flow(0), capacity(capacity), rev(0) {}
};

typedef vector < vector < Edge * > > edges_t;

Edge * addEdge(edges_t & edges, int from, int to, int capacity) {
	//cout << from << " " << to << endl;
	Edge * fi = new Edge(to, capacity);
	Edge * se = new Edge(from, 0);
	fi->rev = se;
	se->rev = fi;
	edges[from].push_back(fi);
	edges[to].push_back(se);
	return fi;
}

const int MAXN = 1010;

int q[MAXN], cameFrom[MAXN], levels[MAXN], mt[MAXN];
Edge * edgeUsed[MAXN];
bool used[MAXN];
bool reachFirst[MAXN], reachSecond[MAXN];

bool bfs(edges_t & edges, int vertices, int from, int to) {
	fill(levels, levels + vertices, 0);
	levels[from] = 1;
	int qs = 0, qt = 0;
		q[qt++] = from;
		fill(used, used + vertices, false);
		used[from] = true;
		while(qs != qt) {
			int u = q[qs++];
			for(int i = 0; i < edges[u].size(); i++) {
				Edge * e = edges[u][i];
				if(e->flow < e->capacity && !used[e->to]) {
					used[e->to] = true;
					levels[e->to] = levels[u] + 1;
					q[qt++] = e->to;
				}
			}
		}
	return used[to];
}

bool dfs(edges_t & edges, int vertices, int from, int to) {
	if(from == to)
		return true;
	for(int & i = mt[from]; i < edges[from].size(); i++) {
		Edge * e = edges[from][i];
		if(e->flow < e->capacity && levels[from] + 1 == levels[e->to]) {
			bool can = dfs(edges, vertices, e->to, to);
			if(can) {
				e->flow += 1;
				e->rev->flow -= 1;
				return true;
			}
		}
	}
	return false;
}

int findMaxFlow(edges_t & edges, int vertices, int from, int to) {
	int result = 0;
	while(bfs(edges, vertices, from, to)) {
		fill(mt, mt + vertices, 0);
		while(dfs(edges, vertices, from, to)) {
			++result;
		}
	}
	return result;
}


void bfsFirst(edges_t & edges, int vertices, int from) {
		int qs = 0, qt = 0;
		q[qt++] = from;
		fill(used, used + vertices, false);
		used[from] = true;
		while(qs != qt) {
			int u = q[qs++];
			for(int i = 0; i < edges[u].size(); i++) {
				Edge * e = edges[u][i];
				if(e->flow < e->capacity && !used[e->to]) {
					used[e->to] = true;
					q[qt++] = e->to;
				}
			}
		}
		for(int i = 0; i < vertices; i++)
			reachFirst[i] = used[i];
}

void bfsSecond(edges_t & edges, int vertices, int from) {
		int qs = 0, qt = 0;
		q[qt++] = from;
		fill(used, used + vertices, false);
		used[from] = true;
		while(qs != qt) {
			int u = q[qs++];
			for(int i = 0; i < edges[u].size(); i++) {
				Edge * e = edges[u][i];
				if(e->rev->flow < e->rev->capacity && !used[e->to]) {
					used[e->to] = true;
					q[qt++] = e->to;
				}
			}
		}
		for(int i = 0; i < vertices; i++)
			reachSecond[i] = used[i];
}

void solveOne() {
	int totalVertices = citiesCount + 2;
	int flowFrom = citiesCount, flowTo = citiesCount + 1;
	edges_t edges(totalVertices);
	
	addEdge(edges, flowFrom, cityFrom, roadsCount + 1);
	addEdge(edges, cityTo, flowTo, roadsCount + 1);
	typedef pair < int, int > simple_edge_t;
	vector < simple_edge_t > allEdges(roadsCount);
	vector < Edge * > pointers(roadsCount);
	for(int i = 0; i < roadsCount; i++) {
		int u, v;
		cin >> u >> v;
		--u;
		--v;
		allEdges[i] = make_pair(u, v);
		pointers[i] = addEdge(edges, u, v, 1);
	}
	int maxFlow = findMaxFlow(edges, totalVertices, flowFrom, flowTo);
	int canImprove = 0;
	
	bfsFirst(edges, totalVertices, flowFrom);
	bfsSecond(edges, totalVertices, flowTo);
	
	for(int i = 0; i < roadsCount; i++) {
		if(reachSecond[allEdges[i].first] &&reachFirst[allEdges[i].second]) {
			++canImprove;
		}
	}
	
	if(canImprove != 0)
		++maxFlow;
	
	cout << maxFlow << " " << canImprove << "\n";
}

int main() {
	ios_base::sync_with_stdio(false);
	while(true) {
		cin >> citiesCount >> roadsCount >> cityFrom >> cityTo;
		--cityFrom; --cityTo;
		if(citiesCount == 0)
			break;
		solveOne();
	}
	return 0;
}